using System;
using System.Collections.Generic;
using System.Configuration;
using System.Linq;
using System.Reflection;
using System.Web;
using System.Web.Compilation;
using System.Web.Configuration;
using System.Web.Mvc;
using System.Web.Optimization;
using System.Web.Routing;
using FluentValidation.Mvc;
using HIPS.Web.Components.Web;
using HIPS.Web.UI.Controllers;
using MvcAuthorization.Policy;
using Nehta.VendorLibrary.Common;

namespace HIPS.Web.UI
{
    // Note: For instructions on enabling IIS6 or IIS7 classic mode, 
    // visit http://go.microsoft.com/?LinkId=9394801
    [Authorize]
    public class MvcApplication : HttpApplication
    {
        /// <summary>
        /// Builds a list of policy handler types in the current AppDomain and retrieves their metadata.
        /// </summary>
        /// <returns></returns>
        internal static List<Tuple<Type, PolicyMetadataAttribute>> LoadAndCachePolicyHandlers()
        {
            List<Tuple<Type, PolicyMetadataAttribute>> result = new List<Tuple<Type, PolicyMetadataAttribute>>();

            // Changed to BuildManager.GetReferencedAssemblies() here
            var policyHandlerTypes = BuildManager.GetReferencedAssemblies().Cast<Assembly>().SelectMany(x => x.GetTypes())
                                                    .Where(t => typeof(IAuthorizationPolicy).IsAssignableFrom(t) && !t.IsAbstract && t.IsClass && t.IsPublic && !t.IsGenericType);

            result = policyHandlerTypes
                .Select(x => new Tuple<Type, PolicyMetadataAttribute>(x, (PolicyMetadataAttribute)Attribute.GetCustomAttribute(x, typeof(PolicyMetadataAttribute)))).ToList();


            // Find empty handlers
            var emptyPolicyHandlers = result.Where(x => x.Item2 == null || string.IsNullOrWhiteSpace(x.Item2.Name));

            if (emptyPolicyHandlers.Count() > 0)
            {
                throw new ApplicationException(string.Format("Policy names are required. The following policy type(s) inherit from IAuthorizationPolicy but do not have a policy name set through the PolicyMetadataAttribute: {0}", string.Join(", ", emptyPolicyHandlers.Select(g => g.Item1.FullName))));
            }

            // Find duplicates and throw an error if there is more than one policy handler with the same name
            var duplicateHandlers = result.Where(x => x.Item2 != null).Select(x => x.Item2).GroupBy(x => x.Name).Where(x => x.Count() > 1);

            if (duplicateHandlers.Count() > 0)
            {
                throw new ApplicationException(string.Format("Policy names must be unique. The following policy name(s) were found more than once: {0}", string.Join(", ", duplicateHandlers.Select(g => g.Key))));
            }

            return result;
        }

        protected void Application_Start()
        {

            typeof (MvcAuthorization.Policy.AuthorizationPolicy).Assembly
                .GetType("MvcAuthorization.Policy.PolicyHelper")
                .GetField("_policyHandlerTypeListCache", BindingFlags.Static | BindingFlags.NonPublic)
                .SetValue(null,
                    new Lazy<List<Tuple<Type, PolicyMetadataAttribute>>>(() => LoadAndCachePolicyHandlers()));
            // Register Areas (Currently Unused)
            //AreaRegistration.RegisterAllAreas();

            // Register Routes
            RouteConfig.RegisterRoutes(RouteTable.Routes);

            // Register Javascript + CSS Bundles
            BundleConfig.RegisterBundles(BundleTable.Bundles);

            // Register Validators
            RegisterValidatorProviders();

            // Register Model Binders
            RegisterModelBinders();
        }

        public static void RegisterModelBinders()
        {
            ModelBinders.Binders.Add(typeof(DateTime), new CultureAwareDateBinder());
            ModelBinders.Binders.Add(typeof(DateTime?), new CultureAwareNullableDateBinder());
        }
        
        public virtual void RegisterValidatorProviders()
        {
            // Register FluentValidation (TODO: Verify if needed for nested data annotations)
            FluentValidationModelValidatorProvider.Configure();
        }

        protected void Application_EndRequest()
        { 
            // TODO: A better way to address error handling responses and still allow 422 or others as passthrough.
            if (Response.StatusCode != 422)
            {
                // Setting status to itself triggers internal response behaviour
                // This allows Exceptions to redirect via httpErrors element to the error controller
                Response.Status = Response.Status;
            }
        }
    }
}